define(["logger"], function(logger){
  debug = 0;

  function contents(source)
  {
    var ab = new ArrayBuffer(source.length*4);
    var view = new Uint32Array(ab);
    for (var a = 0;a<source.length; a++)
    {
        view[a] = source.charCodeAt(a);
    }
    return view;
  }

  function enable(val)
  {
    debug = (val)?1:0;
  }

  function persist()
  {
    require(['models/tabs','models/sites', 'models/windows'], function(t,s,w){
      t.persistence.save();
      s.persistence.save();
      w.persistence.save();
    });
  }

  function reset()
  {
    require(['background/storage'], function(store){
      store.remove("sites");
      store.remove("tabs");
      store.remove("windows");
    });
  }

  function load()
  {
    require(['models/tabs','models/sites', 'models/windows'], function(t,s,w){
      t.persistence.load();
      s.persistence.load();
      w.persistence.load();
    });
  }

  return {
    contents: contents,
    log: logger.debug,
    debug: enable,
    persist: persist,
    load: load,
    reset: reset
  };
});
