define('lib/batch',[], function(){
  var tokens = {};

  function squash(token, squashDuration){
    if (!tokens[token])
    {
      // Create
      tokens[token] = { validity: Date.now() };
    }

    var fn = function(request){
      var t = tokens[token];

      return new Promise(function(resolve, reject) {
        if (Date.now() >= t.validity) {
          t.validity = Date.now() + squashDuration;
            resolve(request);
        }
      });
    };
    return fn;
  }

  return {
    squash: squash,
    tokens: tokens
  };
});
