define('lib/queue',['background/storage'], function(storage){

  //code.stephenmorley.org
  queue.prototype.getLength = function() {
    Promise.all([storage.get('a'), storage.get('b')]).then(function (values) {
      this.a = values[0].a;
      this.b = values[1].b;
      return this.a.length - this.b;
    });
  };

  queue.prototype.isEmpty = function() {
    storage.get('a').then(function (result) {
      if (result) {
        return 0 == result.a.length
      }
    });
  }

  queue.prototype.enqueue = function(b) {
    storage.get('a').then(function (result) {
      if (result) {
        if (b.phrasematch && b.phrasematch.time) {
          b.phrasematch.time = b.phrasematch.time.toISOString();
          result.a.push(b);
        } else {
          result.a.push(b);
        }
        storage.set({ 'a': result.a });
      }
    });
  }

  queue.prototype.dequeue = function() {
    Promise.all([storage.get('a'), storage.get('b')]).then(function (values) {
      this.a = values[0].a;
      this.b = values[1].b;
      if (0 != this.a.length) {
        var c = this.a[this.b];
        2 * (++this.b) >= this.a.length && (this.a = this.a.slice(this.b), this.b = 0);
        storage.set({ 'a': this.a });
        storage.set({ 'b': this.b });
        return c
      }
    });
  }

  queue.prototype.peek = function(callback) {
    setTimeout(function () {
      Promise.all([storage.get('a'), storage.get('b')]).then(function (values) {
        this.a = values[0].a;
        this.b = values[1].b;
        result = 0 < this.a.length ? this.a[this.b] : void 0;
        callback(result);
      });
    }, 2500);
  }

  function queue() {
    Promise.all([storage.get('a'), storage.get('b')]).then(function (values) {
      this.a = values[0].a;
      this.b = values[1].b;
      if (this.a === undefined) {
        this.a = [],
        this.b = 0;
        storage.set({ 'a': this.a });
        storage.set({ 'b': this.b });
      }

    });
    return this;
  }
  return { "queue": queue };
})
